#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ******** MPR Arbitrary *******

Function MPRArbReset()
	MPRArbSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "arbComputeButton(\"\")"
End


Function ButtonMPRArbitrary(ctrlName) : ButtonControl
	String ctrlName

	DoWindow/F WMIFDLArbGraph
	if( V_Flag==0 )
		MPRArbSetupDesign()
	endif
End

Function MPRArbSetupDesign()

	SetApplyButtonTitle(0)

	Variable/G root:Packages:WM_IFDL:mai_n
	NVAR mai_n= root:Packages:WM_IFDL:mai_n
	if( mai_n < 5 )
		mai_n = 41
	endif
	
	Variable/G root:Packages:WM_IFDL:mai_nbands
	NVAR mai_nbands= root:Packages:WM_IFDL:mai_nbands
	if( mai_nbands < 2 )
		mai_nbands = 2
	endif
	
	Variable doPreset= 0
	NVAR fs= root:Packages:WM_IFDL:fs
	String dfSav= Set_IFDL_DataFolder()
	WAVE ry= mai_response
	if( WaveExists(ry) == 0 )
		Make/O/N=4 mai_response
		Make/O/N=4 mai_responseX
		Make/O/N=4 mai_responseDB
		Make/O/N=4 mai_weighting
		Make/O/N=4 mai_weightingX
		// Save fs in the response wave's scaling
		WAVE ry= mai_response
		SetScale/P x,0,fs,"" ry	// yes, this will result in weird results if X scaling is used, but it isn't
		doPreset= 1
	else // rescale existing mai_responseX and mai_weightingX for possibly new fs
		Variable oldFs= deltax(ry)
		if( (oldFS != fs) %& ( oldFS != 0 ) )
			WAVE rx= mai_responseX
			rx *= fs/oldFS
			WAVE wx= mai_weightingX
			wx  *= fs/oldFS
			WAVE tx= mai_transitionRegionsX
			if( WaveExists(tx) )
				tx *= fs/oldFS
			endif
		endif	
		WAVE ry= mai_response
		SetScale/P x,0,fs,"" ry
	endif
	SetDataFolder dfSav
	
	CreateWMIFDLArbGraph()
	if( doPreset )
		arbPresetBands(mai_nbands,1)	// lowpass, initially
	endif
End

Function CreateWMIFDLArbGraph()

	if( DesignGraph("WMIFDLArbGraph","Arbitrary Filter Design") )
		return 1	// already existed, don't reset the graph settings.
	endif

	WAVE rx= root:Packages:WM_IFDL:mai_responseX
	WAVE ry= root:Packages:WM_IFDL:mai_response
	WAVE wx= root:Packages:WM_IFDL:mai_weightingX
	WAVE wy= root:Packages:WM_IFDL:mai_weighting
	AppendToGraph/L=responseLeft ry vs rx
	AppendToGraph/L=weightingLeft wy vs wx

	ModifyGraph rgb(mai_weighting)=(0,0,0)
	ModifyGraph margin(left)=51
	ModifyGraph minor(bottom)=1
	ModifyGraph nticks(weightingLeft)=2
	ModifyGraph lblPos(responseLeft)=46,lblPos(weightingLeft)=46
	ModifyGraph freePos(responseLeft)={0,bottom}
	ModifyGraph freePos(weightingLeft)={0,bottom}
	ModifyGraph axisEnab(responseLeft)={0,0.65}
	ModifyGraph axisEnab(weightingLeft)={0.75,1}
	Label responseLeft "response"
	Label weightingLeft "weighting"
	SetAxis/A/N=1 responseLeft
	SetAxis/A/N=1/E=1 weightingLeft
	ControlBar 82
	CheckBox dBCheck,pos={165,58},size={110,15},proc=ArbCheck,title="dB Response",value=0
	Button arbEditResp,pos={157,32},size={120,20},proc=arbRespButtons,title="Edit Response"
	Button arbEditWeighting,pos={158,7},size={119,20},proc=arbWeightButtons,title="Edit Weighting"
	Button arbCompute,pos={358,29},size={120,20},proc=arbComputeButton,title="Compute Filter"
	SetVariable arbBands,pos={12,7},size={129,17},title="Preset Bands"
	SetVariable arbBands,font="Chicago"
	SetVariable arbBands,limits={2,50,1},value= root:Packages:WM_IFDL:mai_nbands
	PopupMenu arbFirstBand,pos={9,29},size={127,19},title="First Band"
	PopupMenu arbFirstBand,mode=1,popvalue="Pass",value= #"\"Pass;Reject\""
	SetVariable arbTerms,pos={344,8},size={135,17},title="Filter Terms"
	SetVariable arbTerms,font="Chicago"
	SetVariable arbTerms,limits={5,Inf,2},value= root:Packages:WM_IFDL:mai_n
	Button arbPreset,pos={17,53},size={120,20},proc=arbPresetButton,title="Preset Bands"
	Button arbResetWeight,pos={285,7},size={50,20},proc=arbWeightButtons,title="None"
	ValDisplay text0,pos={301,54},size={130,14},fSize=9
	ValDisplay text0,format="Use marquee to define or",frame=0
	ValDisplay text0,limits={0,0,0},barmisc={0,1000},value= #"0"
	ValDisplay text1,pos={301,65},size={130,14},fSize=9
	ValDisplay text1,format="remove a transition region.",frame=0
	ValDisplay text1,limits={0,0,0},barmisc={0,1000},value= #"0"

	arbDisplayTransitions()
	arbLegend()
	SetWindow WMIFDLArbGraph, hook=designHook
	return 0
end

Function arbNormal()
	GraphNormal
	arbFixWeightingAndResponse()	// eliminate negative amplitudes, force first X to 0, last X to fs/2
	SetAxis/A/E=1/N=2 weightingLeft
	Button arbEditWeighting title="Edit Weighting"
	SetAxis/A/N=1 responseLeft
	Button arbEditResp title="Edit Response"
end

Function ArbCheck(ctrlName,isdB) : CheckBoxControl
	String ctrlName
	Variable isdB

	arbNormal()	// fixes X values, but not Y values

	// swap desired response waves
	Wave wv= root:Packages:WM_IFDL:mai_response
	WAVE dbwv= root:Packages:WM_IFDL:mai_responseDB
	SwapResponseLeftWaves(wv,dbwv,isdB)
	
	// swap actual response waves
	dBCheck(isdB)
	
	arbLegend()
End

Function arbResetWeight(weight)
	Variable weight
	WAVE wy= root:Packages:WM_IFDL:mai_weighting
	WAVE wx= root:Packages:WM_IFDL:mai_weightingX
	NVAR fs=root:Packages:WM_IFDL:fs
	Redimension/N=2 wx,wy
	wy= weight
	wx={0,fs/2}
	SetAxis/A/E=1/N=2 weightingLeft
End

Function arbWeightButtons(ctrlName) : ButtonControl
	String ctrlName
	
	String title= ControlTitle(WinName(0,65),ctrlName)
	
	arbNormal()	// this changes the title of arbEditWeighting
	
	if( CmpStr("Edit Weighting",title) == 0 )
		Button $ctrlName title="Finish Weighting"
		GraphWaveEdit/M mai_weighting
	endif
	if( CmpStr("arbResetWeight",ctrlName) == 0 )
		 arbResetWeight(1)
	endif
End

Function arbRespButtons(ctrlName) : ButtonControl
	String ctrlName
	
	String title= ControlTitle("WMIFDLArbGraph",ctrlName)
	Variable readyToEdit= CmpStr("Edit Response",title) == 0
	
	arbNormal()
	
	if( readyToEdit )
		Button $ctrlName title="Finish Response", win=WMIFDLArbGraph
		WAVE ry= root:Packages:WM_IFDL:mai_response
		CheckDisplayed/W=WMIFDLArbGraph ry
		if( V_Flag)
			GraphWaveEdit/M mai_response
		else
			WAVE ryDB= root:Packages:WM_IFDL:mai_responseDB
			CheckDisplayed/W=WMIFDLArbGraph ryDB
			if( V_Flag)
				GraphWaveEdit/M mai_responseDB
			endif
		endif
	endif

End

Function arbPresetBands(bands,firstIsPass)
	Variable bands, firstIsPass
	
	NVAR fs= root:Packages:WM_IFDL:fs
	Variable df= 0.5*fs/bands
	Variable halfTransition= df/16
	WAVE rx= root:Packages:WM_IFDL:mai_responseX
	WAVE ry= root:Packages:WM_IFDL:mai_response
	WAVE wx= root:Packages:WM_IFDL:mai_weightingX
	WAVE wy= root:Packages:WM_IFDL:mai_weighting
	Redimension/N=(2*bands) rx,ry
	Redimension/N=(4*bands) wx,wy
	Variable resp,center,band=0

	if( firstIsPass )
		resp= 1
	else
		resp= 1e-6		// close to zero, prevents dB from being NaN
	endif
	arbAddDelRegion(-1,fs,1,0)	// delete all transitions
	do
		rx[band*2] = band * df
		rx[band*2+1] = (band+1) * df
		ry[band*2,band*2+1] = resp

		wx[band*4] = band * df + halfTransition
		wx[band*4+1] = band * df + halfTransition
		wx[band*4+2] = (band+1) * df - halfTransition
		wx[band*4+3] = (band+1) * df - halfTransition
		wy[band*4]   = 0.5 // band * df + halfTransition
		wy[band*4+1] = 1 // band * df + halfTransition
		wy[band*4+2] = 1 // (band+1) * df - halfTransition
		wy[band*4+3] = 0.5 // (band+1) * df - halfTransition
		band += 1
		if( band < bands ) // another band is coming, need a transition band
			center= band * df
			arbAddDelRegion(center-halfTransition,center+halfTransition,0,0)	// add a transition band around band * df
		endif
		if( resp == 1 )
			resp= 1e-6
		else
			resp= 1
		endif

	while( band < bands	)
	DeletePoints 0,1, wx,wy				// delete first
	DeletePoints numpnts(wx)-1,1,wx,wy	// and last point of weighting wave
	arbFixWeightingAndResponse()
	Duplicate/O ry, root:Packages:WM_IFDL:mai_responseDB
	WAVE ryDB= root:Packages:WM_IFDL:mai_responseDB
	ryDB = 20 * log(ry)
End

// eliminates negative weightings (but allows negative responses),
// forces first X to 0, last X to fs/2
// copies current response to hidden response (dB -> linear or vice versa)
Function arbFixWeightingAndResponse()

	Variable npnts
	NVAR fs= root:Packages:WM_IFDL:fs
	
	// Fix Responses
	WAVE rx= root:Packages:WM_IFDL:mai_responseX
	if( WaveExists(rx) )
		npnts= numpnts(rx)
		rx[0]= 0
		rx[npnts-1] = fs/2
		//  Transfer visible response wave to wave that is hidden
		WAVE ry= root:Packages:WM_IFDL:mai_response
		WAVE ryDB= root:Packages:WM_IFDL:mai_responseDB
		CheckDisplayed/W=WMIFDLArbGraph ry
		if( V_Flag )	// linear is displayed, most recently edited
			Duplicate/O ry, root:Packages:WM_IFDL:mai_responseDB
			ryDB = 20 * log(limit(ry,1e-12,inf))
		else
			Duplicate/O ryDB, root:Packages:WM_IFDL:mai_response
			ry = 10^(ryDB/20)
		endif
	endif
	// Fix Weighting
	WAVE wx= root:Packages:WM_IFDL:mai_weightingX
	if( WaveExists(wx) )
		npnts= numpnts(wx)
		wx[0]= 0
		wx[npnts-1] = fs/2
		WAVE wy= root:Packages:WM_IFDL:mai_weighting
		wy= limit(wy,1e-6,inf)
	endif
End

Function arbPresetButton(ctrlName) : ButtonControl
	String ctrlName

	Variable isPass= 1
	ControlInfo arbFirstBand
	if( (V_Flag == 3) %& (V_Value == 2) )
		isPass= 0	// reject
	endif

	NVAR bands= root:Packages:WM_IFDL:mai_nbands
	
	arbNormal()
	arbPresetBands(bands,isPass)
End

Function arbAddDelRegion(f1,f2,isDelete,debugLevel)
	Variable f1,f2,isDelete,debugLevel
	
	if( f1 > f2 )
		Variable tmp=f1
		f1= f2
		f2= tmp
	endif
	String debugLevelPrefix= "                   "[0,debugLevel*2+1]+num2istr(debugLevel)+": "
	WAVE trans= root:Packages:WM_IFDL:mai_transitionRegions
	if( !WaveExists(trans) )
		if( isDelete )
			return 0
		endif
		Make/O root:Packages:WM_IFDL:mai_transitionRegions= {inf,inf,NaN}
		Make/O root:Packages:WM_IFDL:mai_transitionRegionsX= {f1, f2, NaN}
		WAVE trans= root:Packages:WM_IFDL:mai_transitionRegions
		WAVE transX= root:Packages:WM_IFDL:mai_transitionRegionsX
	else
		WAVE transX= root:Packages:WM_IFDL:mai_transitionRegionsX
		Variable pntsPerBand= 3
		Variable tbands=numpnts(trans)/pntsPerBand
		Variable i=0,bandF1,bandF2,firstNdx
		if( isDelete )
			// Print debugLevelPrefix+"Delete: f1=",f1,"f2=",f2
			// search through the list for f1 or f2 within any band
			if( tbands > 0 )
				do
					firstNdx= i*pntsPerBand		// point index of first item in the ith band
					bandF1= transX[firstNdx]		// band min
					bandF2= transX[firstNdx+1]	// band max
					// Print debugLevelPrefix+ "Delete: i=",i,"bandF1=",bandF1,"bandF2=",bandF2
					if( (f2 > bandF1) %& (f1 < bandF2) ) 	// overlap of some kind
						if( f1 <= bandF1 )
							if( f2 >= bandF2 )
								// Print debugLevelPrefix+ "Delete case 1: f1 <= band min, f2 >= band max (delete the band)"
								DeletePoints firstNdx, pntsPerBand, trans, transX
								tbands -= 1
								i -= 1
							else
								// Print debugLevelPrefix+ "Delete case 2: f1 <= band min, f2 < band max (lose lower part of band)"
								transX[firstNdx] = f2 // remove from old f1 to new f2
							endif
						else
							if( f2 >= bandF2 )
								// Print debugLevelPrefix+ "Delete case 3: f1 > band min, f2 >= band max (lose upper part of band)"
								transX[firstNdx+1] = f1 // remove from new f1 to old f2
							else
								// Print debugLevelPrefix+ "Delete case 4: f1 > band min, f2 < band max (split into two bands)"
								InsertPoints firstNdx, pntsPerBand, trans, transX
								tbands += 1
								trans[firstNdx]={inf,inf,NaN}
								transX[firstNdx]={bandF1,f1,NaN}
								transX[firstNdx+pntsPerBand]={f2,bandF2,NaN}
								i+=1
							endif
						endif
					endif
					i+=1
				while( i < tbands )
			endif
		else	// add
			// Print debugLevelPrefix+ "Add: f1=",f1,"f2=",f2
			Variable addTheBand= 1
			if( tbands > 0 )
				// merge overlapping bands
				do
					firstNdx= i*pntsPerBand		// point index of first item in the ith band
					bandF1= transX[firstNdx]	// band min
					bandF2= transX[firstNdx+1]	// band max
					// Print debugLevelPrefix+ "Add: i=",i,"bandF1=",bandF1,"bandF2=",bandF2
					if( (f2 > bandF1) %& (f1 < bandF2) ) 	// overlap of some kind
						if( f1 <= bandF1 )
							if( f2 >= bandF2 )
								// Print debugLevelPrefix+ "Add case 1: f1 <= band min, f2 >= band max (grow the band)"
								arbAddDelRegion(bandF1,bandF2,1,debugLevel+1) // delete old
								arbAddDelRegion(f1,f2,0,debugLevel+1) 			// add new (larger) band (recurses until no overlap)
								addTheBand= 0
								break
							else
								// Print debugLevelPrefix+ "Add case 2: f1 <= band min, f2 < band max (add to lower part of band)"
								arbAddDelRegion(bandF1,bandF2,1,debugLevel+1) // delete old
								arbAddDelRegion(f1,bandF2,0,debugLevel+1) 		// add new (larger) band (recurses until no overlap)
								addTheBand= 0
								break
							endif
						else
							if( f2 >= bandF2 )
								// Print debugLevelPrefix+ "Add case 3: f1 > band min, f2 >= band max (add to upper part of band)"
								arbAddDelRegion(bandF1,bandF2,1,debugLevel+1) // delete old
								arbAddDelRegion(bandF1,f2,0,debugLevel+1) 		// add new (larger) band (recurses until no overlap)
								addTheBand= 0
								break
							else
								// Print debugLevelPrefix+ "Add case 4: f1 > band min, f2 < band max (inside old band, nothing to do)"
								addTheBand= 0
								break
							endif
						endif
					endif
					i+=1
				while( i < tbands )
			endif
			if( addTheBand )
				// add a the new band at then end
				firstNdx= numpnts(trans)
				InsertPoints firstNdx, pntsPerBand, trans, transX
				// Print debugLevelPrefix+ "Add: adding band, f1=",f1,"f2=",f2, "numpnts= ",numpnts(trans)
				trans[firstNdx]={inf,inf,NaN}
				transX[firstNdx]={f1,f2,NaN}
			endif
		endif
	endif
	// Print debugLevelPrefix+ "numpnts(mai_transitionRegions) = ",numpnts(trans)
	
	Duplicate/O trans root:Packages:WM_IFDL:mai_transitionRegionsMinus
	WAVE transMinus=  root:Packages:WM_IFDL:mai_transitionRegionsMinus
	transMinus= -trans		// -inf wherever trans was +inf, such as {-inf,-inf,NaN}

	arbDisplayTransitions()
	return 0
End

Function arbDisplayTransitions()
	if( CmpStr("WMIFDLArbGraph",WinName(0,255)) != 0 )
		return 0		// arb graph not up, yet
	endif
	WAVE trans= root:Packages:WM_IFDL:mai_transitionRegions
	if( !WaveExists(trans) )
		return 0
	endif
	CheckDisplayed trans
	if( V_Flag != 0 )
		return 0		// trans already appended
	endif

	WAVE transX= root:Packages:WM_IFDL:mai_transitionRegionsX
	WAVE transMinus=  root:Packages:WM_IFDL:mai_transitionRegionsMinus
	AppendToGraph/L=responseLeft trans,transMinus vs transX
	WMMoveTraceToBottom("WMIFDLArbGraph","mai_transitionRegionsMinus")
	WMMoveTraceToBottom("WMIFDLArbGraph","mai_transitionRegions")
	ModifyGraph mode(mai_transitionRegions)=7,toMode(mai_transitionRegions)=1
	ModifyGraph lsize(mai_transitionRegions)=0, lsize(mai_transitionRegionsMinus)=0
	ModifyGraph hbFill(mai_transitionRegions)=2
	ModifyGraph rgb(mai_transitionRegions)=(56797,56797,56797)
	arbLegend()
end

// Set regions in grid to NaN where there is a transition region
Function arbTransitionsToGrid(grid)
	Wave grid

	WAVE transX= root:Packages:WM_IFDL:mai_transitionRegionsX
	NVAR fs = root:Packages:WM_IFDL:fs
	Variable pntsPerBand= 3
	Variable tbands=numpnts(transX)/pntsPerBand
	Variable i=0,firstNdx,p1,p2
	
	if( tbands > 0 )
		do
			firstNdx= i*pntsPerBand	// point index of first item in the ith band

			p1= x2pnt(grid,transX[firstNdx]/fs)
			p2= x2pnt(grid,transX[firstNdx+1]/fs)
			grid[p1,p2] = NaN
			i+=1
		while( i < tbands )
	endif
End

Function Add_Transition_Region() : GraphMarquee
	
	if( CmpStr(WinName(0,255),"WMIFDLArbGraph") != 0 )
		Abort "Add_Transition_Region is used only for Arbitrary Filter Design"
	endif
	GetMarquee/K responseLeft, bottom
	arbAddDelRegion(V_left,V_Right,0,0)		// add	
End

Function Remove_Transition_Region() : GraphMarquee

	if( CmpStr(WinName(0,255),"WMIFDLArbGraph") != 0 )
		Abort "Remove_Transition_Region is used only for Arbitrary Filter Design"
	endif
	GetMarquee/K responseLeft, bottom
	arbAddDelRegion(V_left,V_Right,1,0)		// delete
End

Proc Set_Weighting_Value() : GraphMarquee

	Silent 1;PauseUpdate
	if( CmpStr(WinName(0,255),"WMIFDLArbGraph") != 0 )
		Abort "Set_Weighting_Value is used only for Arbitrary Filter Design"
	endif
	GetMarquee/K responseLeft, bottom
	if( V_left < V_right )
		SetWeightingOverRange(V_left,V_right,)		// weight value missing
	else
		SetWeightingOverRange(V_right,V_left,)		// weight value missing
	endif
End

Proc SetWeightingOverRange(xLow,xHi,weight)
	Variable xLow,xHi,weight=1
	Prompt weight, "weighting value (0 to infinity):"
	
	Silent 1;PauseUpdate
	if( weight != limit(weight,0,inf) )
		Abort "illegal weight: must be 0 or positive value!"
	endif
	
	String dfSav= Set_IFDL_DataFolder()

	// prevent human error from causing problems
	xLow= limit(xLow,0, fs/2)
	xHi= limit(xHi,0, fs/2)
	
//	if( (xLow == 0) %& (xHi >= fs/2) )
//		SetDataFolder dfSav	
//		arbResetWeight(weight)
//		return
//	endif

	mai_weightingX[0]= 0
	mai_weightingX[numpnts(mai_weightingX)-1] = fs/2
	
	// Determine current weighting values at xLow and xHi, so that they don't change
	Variable wLow=	interp(xLow,mai_weightingX,mai_weighting)
	Variable wHi= interp(xHi,mai_weightingX,mai_weighting)
	
	// Remove any weighting values in the Xrange
	Variable beforeOrAtLow = BinarySearch(mai_weightingX,xLow)
	Variable firstToDelete
	if( mai_weightingX[beforeOrAtLow] == xLow ) 	// at
		firstToDelete= beforeOrAtLow			// delete this, because we'll replace it
	else		// before
		firstToDelete= beforeOrAtLow+1		// we need beforeOrAtLow because it has a different weighting
	endif
	
	Variable lastToDelete = BinarySearch(mai_weightingX,xHi)
	DeletePoints firstToDelete, (lastToDelete - firstToDelete + 1), mai_weightingX,mai_weighting
	
	// Insert 4 points, two at xLow and two at xHigh (one is current weight, the other is the new weight)
	InsertPoints firstToDelete, 4, mai_weightingX,mai_weighting
	mai_weightingX[firstToDelete,firstToDelete+3] = {xLow,xLow,xHi,xHi}
	mai_weighting[firstToDelete,firstToDelete+3] = {wLow,weight,weight,wHi}
	
	// Remove any redundant values
	if( mai_weightingX[0] == mai_weightingX[1] )
		DeletePoints 0,1,mai_weightingX,mai_weighting
	endif
	Variable n= numpnts(mai_weightingX)
	if( (n > 2 ) %& (mai_weightingX[n-2] == mai_weightingX[n-1]) )
		DeletePoints n-1,1,mai_weightingX,mai_weighting
	endif

	SetDataFolder dfSav	
End

Proc arbComputeButton(ctrlName) : ButtonControl
	String ctrlName

	Silent 1;PauseUpdate
	arbNormal()

	// print warning if any part of the requested response is negative...
	WaveStats/Q root:Packages:WM_IFDL:mai_response
	if( V_min < 0 )
		DoAlert 2, "Desired response includes negative values. Change them to zero?"
		if( V_Flag == 3 )	// cancel
			return 0
		endif
		if( V_Flag == 1 )	// yes
			root:Packages:WM_IFDL:mai_response= limit(root:Packages:WM_IFDL:mai_response,0,inf)
		endif
	endif

	String dfSav= Set_IFDL_DataFolder()

	// fix the design waves to allow for human error...
	mai_responseX[0]= 0; mai_responseX[numpnts(mai_responseX)-1] = fs/2
	mai_weightingX[0]= 0; mai_weightingX[numpnts(mai_weightingX)-1] = fs/2
	mai_weighting= limit(mai_weighting,0,inf)		// the weighting values must be positive

	Variable nt= max(5, 1 + 2 * trunc(mai_n/2))
	if( nt != mai_n )
		ControlUpdate/W=WMIFDLArbGraph arbTerms
		mai_n= nt
	endif
	
	String mpDes="des"
	String mpWt="wt"
	String mpGrid="grid"

	// make the design and grid waves expected by MPKernel
	String umpDes="desresp"
	String umpWt="wghtng"
	String umpGrid="usergrid"

	String/G proposedFilterName="mprArbitrary"
	String/G designTypeName="McClellan-Parks; arbitrary response"
	Variable/G designFlags=0

	MPRMakeWaves("des","wt","grid",nt)	// X scaling from 0 to just below 0.5 (normalized frequencies), used by MPKernel
	
	// convert from XY in frequency units to waveform in normalized frequencies
	des= interp(x*fs,mai_responseX,mai_response)
	wt= interp(x*fs,mai_weightingX,mai_weighting)

	// set unwanted (transition) points to NaNs
	arbTransitionsToGrid(grid)
	arbTransitionsToGrid(des)
	
	KillWaves/Z bandInfo	// not used, don't pack into the note
	SetDataFolder dfSav		// make coefs...
	Make/O/N=(nt) coefs	// ...in the user's data folder

	// design, weighting, and grid waves are killed by MPKernel()
	MPKernel("des","wt","grid","coefs",0)
	StdCoefsTreatmentNoShowResults(4+8+0x40,1)	// want results, but don't automatically show anything, even after Quantize Coefs..
	CheckDisplayed/W=WMIFDLArbGraph root:Packages:WM_IFDL:coefsMag,root:Packages:WM_IFDL:coefsDbMag
	if( V_Flag == 0 )
		DoWindow/F WMIFDLArbGraph
		Variable wantDB= dBIsChecked("WMIFDLArbGraph")
		Append/L=responseLeft $responseName(wantDB,1)
		String traceName= responseName(wantDB,0)
		ModifyGraph rgb($traceName)=(0,0,65535)
	endif
	AutoApplyFilter()
	arbLegend()		// brings design window back up
End

Function arbLegend()
	DesignLegend("WMIFDLArbGraph","mai","arbLegend")
End

